% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_n.R
\name{adjust_n_d}
\alias{adjust_n_d}
\title{Adjusted sample size for a non-Cohen \emph{d} value for use in a meta-analysis of Cohen's \emph{d} values}
\usage{
adjust_n_d(d, var_e, p = NA)
}
\arguments{
\item{d}{Vector of non-Cohen \mjseqn{d} standardized mean differences.}

\item{var_e}{Vector of error variances of standardized mean differences.}

\item{p}{Proportion of participants in a study belonging to one of the two groups being contrasted.}
}
\value{
A vector of adjusted sample sizes.
}
\description{
\loadmathjax
This function is used to convert a non-Cohen \mjseqn{d} value (e.g., Glass' \mjeqn{\Delta}{\Delta}) to a Cohen's \mjseqn{d} value by identifying the sample size of a Cohen's \mjseqn{d} that has the
same standard error as the non-Cohen \mjseqn{d}. This function permits users to account for the influence of sporadic corrections on the sampling variance of \mjseqn{d} prior to use in a meta-analysis.
}
\details{
The adjusted sample size is computed as:
\mjdeqn{n_{adjusted}=\frac{d^{2}p(1-p)+2}{2p(1-p)var_{e}}}{n_adjusted = ((d^2 * p * (1 - p) + 2) / (2 * p * (1 - p) * var_e))}
}
\examples{
adjust_n_d(d = 1, var_e = .03, p = NA)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Sage. \doi{10.4135/9781483398105}. Chapter 7 (Equations 7.23 and 7.23a).
}
