% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_matrix}
\alias{simulate_matrix}
\title{Generate a list of simulated sample matrices sampled from the Wishart distribution}
\usage{
simulate_matrix(sigma, n, k = 1, as_cor = FALSE)
}
\arguments{
\item{sigma}{Population covariance matrix. May be standardized or unstandardized.}

\item{n}{Sample size for simulated sample matrices.}

\item{k}{Number of sample matrices to generate.}

\item{as_cor}{Should the simulated matrices be standardized (\code{TRUE}) or unstandardized (\code{FALSE})?}
}
\value{
A list of simulated sample matrices.
}
\description{
This function generates simulated sample matrices based on a population matrix and a sample size.
It uses the Wishart distribution (i.e., the multivariate \eqn{\chi^{2}}{\chi^2} distribution) to obtain data, rescales the data into the input metric, and can be standardized into a correlation matrix by setting \code{as_cor} to \code{TRUE}.
The function can produce a list of matrices for any number of samples.
}
\examples{
## Define a hypothetical matrix:
sigma <- reshape_vec2mat(cov = .4, order = 5)

## Simualte a list of unstandardized covariance matrices:
simulate_matrix(sigma = sigma, n = 50, k = 10, as_cor = FALSE)

## Simualte a list of correlation matrices:
simulate_matrix(sigma = sigma, n = 50, k = 10, as_cor = TRUE)
}
\keyword{distribution}
