% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.stanreg.R
\name{analyze.stanreg}
\alias{analyze.stanreg}
\title{Analyze stanreg objects.}
\usage{
\method{analyze}{stanreg}(x, CI = 95, Effect_Size = FALSE, ...)
}
\arguments{
\item{x}{stanreg object.}

\item{CI}{Credible interval bounds.}

\item{Effect_Size}{Compute Effect Sizes according to Cohen (1988)? Your outcome variable must be standardized.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze stanreg objects.
}
\examples{
library(psycho)
require(rstanarm)
fit <- rstanarm::stan_glm(vs ~ mpg * cyl, data=mtcars)

results <- analyze(fit)
summary(results)


}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
