% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predicted.stanreg.R
\name{get_predicted.stanreg}
\alias{get_predicted.stanreg}
\title{Compute predicted values of stanreg models.}
\usage{
\method{get_predicted}{stanreg}(fit, prob = 0.9, draws = 500,
  newdf = FALSE, precision = 10, ...)
}
\arguments{
\item{fit}{A stanreg model.}

\item{prob}{Probability of credible intervals (0.9 (default) will compute
5-95\% CI).}

\item{draws}{Precision of the estimate.}

\item{newdf}{Should the predictions be based on actual data or,
generate a new dataframe based on all combinations of values}

\item{precision}{Precision of the new dataframe to be generated.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
dataframe with predicted values.
}
\description{
Compute predicted from a stanreg model.
}
\examples{
\dontrun{
library(psycho)
require(rstanarm)
fit <- rstanarm::stan_glm(vs ~ mpg * cyl, data=mtcars)

predicted <- get_predicted(fit)
}
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
