% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.stanreg.R
\name{analyze.stanreg}
\alias{analyze.stanreg}
\title{Analyze stanreg objects.}
\usage{
\method{analyze}{stanreg}(x, CI = 90, effsize = FALSE, overlap = TRUE,
  ...)
}
\arguments{
\item{x}{A stanreg model.}

\item{CI}{Credible interval bounds.}

\item{effsize}{Compute Effect Sizes according to Cohen (1988)? Your outcome variable must be standardized.}

\item{overlap}{Compute the overlapping coefficient between the posterior and a normal distribution of mean 0 and same SD.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze stanreg objects.
}
\examples{
\dontrun{
library(psycho)
library(rstanarm)

data <- standardize(attitude)
fit <- rstanarm::stan_glm(rating ~ advance + privileges, data=data)

results <- analyze(fit, effsize=TRUE)
summary(results)
plot(results)
print(results)

fit <- rstanarm::stan_glmer(Sepal.Length ~ Sepal.Width + (1|Species), data=iris)
results <- analyze(fit)
summary(results)
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
