% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predicted.glm.R
\name{get_predicted.glm}
\alias{get_predicted.glm}
\title{Compute predicted values of lm models.}
\usage{
\method{get_predicted}{glm}(fit, newdata = "model", prob = 0.95,
  odds_to_probs = TRUE, ...)
}
\arguments{
\item{fit}{An lm model.}

\item{newdata}{A data frame in which to look for variables with which to predict. If omitted, the model matrix is used. If "model", the model's data is used.}

\item{prob}{Probability of credible intervals (0.9 (default) will compute 5-95\% CI). Can also be a list of probs (e.g., c(0.90, 0.95)).}

\item{odds_to_probs}{Transform log odds ratios in logistic models to probabilies.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
dataframe with predicted values.
}
\description{
Compute predicted from a lm model.
}
\examples{
\dontrun{
library(psycho)
library(ggplot2)

fit <- glm(Sex ~ Adjusting, data=affective, family="binomial")

refgrid <- psycho::refdata(affective, "Adjusting")
predicted <- get_predicted(fit, newdata=refgrid)

ggplot(predicted, aes(x=Adjusting, y=Sex_Predicted)) +
  geom_line() +
  geom_ribbon(aes(ymin=Sex_CI_2.5,
                  ymax=Sex_CI_97.5),
                  alpha=0.1)

}
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
