% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_to_priors.R
\name{model_to_priors}
\alias{model_to_priors}
\title{Model to Prior.}
\usage{
model_to_priors(fit, autoscale = FALSE)
}
\arguments{
\item{fit}{A stanreg model.}

\item{autoscale}{Set autoscale.}
}
\description{
Convert a Bayesian model's results to priors.
}
\examples{
\dontrun{
library(rstanarm)
library(psycho)

fit <- stan_glm(Sepal.Length ~ Petal.Width, data=iris)
priors <- model_to_priors(fit)
update(fit, prior=priors$prior)

fit <- stan_glmer(Subjective_Valence ~ Emotion_Condition + (1|Participant_ID), data=psycho::emotion)
priors <- model_to_priors(fit)

fit1 <- stan_glm(Subjective_Valence ~ Emotion_Condition,
    data=filter(psycho::emotion, Participant_ID == "1S"))

fit2 <- stan_glm(Subjective_Valence ~ Emotion_Condition,
    data=filter(psycho::emotion, Participant_ID == "1S"),
    prior=priors$prior, prior_intercept=priors$prior_intercept)
}


}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
