% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_R2.R
\name{R2_nakagawa}
\alias{R2_nakagawa}
\title{Pseudo-R-squared for Generalized Mixed-Effect models.}
\usage{
R2_nakagawa(fit)
}
\arguments{
\item{fit}{A mixed model.}
}
\description{
For mixed-effects models, R² can be categorized into two types. Marginal R_GLMM² represents the variance explained by fixed factors, and Conditional R_GLMM² is interpreted as variance explained by both fixed and random factors (i.e. the entire model). IMPORTANT: Looking for help to reimplement this method.
}
\examples{
\dontrun{
library(psycho)

fit <- lmerTest::lmer(Sepal.Length ~ Sepal.Width + (1 | Species), data = iris)

R2_nakagawa(fit)
}

}
\references{
Nakagawa, S., Johnson, P. C., & Schielzeth, H. (2017). The coefficient of determination R2 and intra-class correlation coefficient from generalized linear mixed-effects models revisited and expanded. Journal of the Royal Society Interface, 14(134), 20170213.
Nakagawa, S., & Schielzeth, H. (2013). A general and simple method for obtaining R2 from generalized linear mixed-effects models. Methods in Ecology and Evolution, 4(2), 133-142.
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
