% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{get_data}
\alias{get_data}
\title{Extract the dataframe used in a model.}
\usage{
get_data(fit, ...)
}
\arguments{
\item{fit}{A model.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Extract the dataframe used in a model.
}
\examples{
\dontrun{
library(tidyverse)
library(psycho)

df <- mtcars \%>\%
  mutate(
    cyl = as.factor(cyl),
    gear = as.factor(gear)
  )

fit <- lm(wt ~ mpg, data = df)
fit <- lm(wt ~ cyl, data = df)
fit <- lm(wt ~ mpg * cyl, data = df)
fit <- lm(wt ~ cyl * gear, data = df)
fit <- lmerTest::lmer(wt ~ mpg * gear + (1 | cyl), data = df)
fit <- rstanarm::stan_lmer(wt ~ mpg * gear + (1 | cyl), data = df)

get_data(fit)
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
