% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mellenbergh.test.R
\name{mellenbergh.test}
\alias{mellenbergh.test}
\title{Mellenbergh & van den Brink (1998) test for pre-post comparison.}
\usage{
mellenbergh.test(t0, t1, controls)
}
\arguments{
\item{t0}{Single value (pretest or baseline score).}

\item{t1}{Single value (posttest score).}

\item{controls}{Vector of scores of the control group OR single value corresponding to the control SD of the score.}
}
\value{
Returns a data frame containing the z-value and p-value. If significant, the difference between pre and post tests is significant.
}
\description{
Test for comparing post-test to baseline for a single participant.
}
\examples{
library(psycho)

mellenbergh.test(t0 = 4, t1 = 12, controls = c(0, -2, 5, 2, 1, 3, -4, -2))
mellenbergh.test(t0 = 8, t1 = 2, controls = 2.6)
}
\author{
Dominique Makowski
}
