% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTDewPointFromRelHum}
\alias{GetTDewPointFromRelHum}
\title{Return dew-point temperature given dry-bulb temperature and relative humidity.}
\usage{
GetTDewPointFromRelHum(TDryBulb, RelHum)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{RelHum}{A numeric vector of relative humidity in range [0, 1]}
}
\value{
A numeric vector of dew-point temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return dew-point temperature given dry-bulb temperature and relative humidity.
}
\examples{
SetUnitSystem("IP")
GetTDewPointFromRelHum(80:100, 0.2)

SetUnitSystem("SI")
GetTDewPointFromRelHum(20:30, 0.4)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
}
