% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetVapPresFromTDewPoint}
\alias{GetVapPresFromTDewPoint}
\title{Return vapor pressure given dew point temperature.}
\usage{
GetVapPresFromTDewPoint(TDewPoint)
}
\arguments{
\item{TDewPoint}{A numeric vector of dew-point temperature in degreeF [IP] or degreeC [SI]}
}
\value{
A numeric vector of partial pressure of water vapor in moist air in Psi [IP] or Pa [SI]
}
\description{
Return vapor pressure given dew point temperature.
}
\examples{
SetUnitSystem("IP")
GetVapPresFromTDewPoint(12:20)

SetUnitSystem("SI")
GetVapPresFromTDewPoint(12:20)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 36
}
