% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{B2}
\alias{B2}
\title{Benchmark set B2}
\format{A vector containg 352 genes' names.}
\source{
The raw data can be downloaded from 
\url{http://www.cbs.dtu.dk/cellcycle/yeast_benchmark/benchmark.php}.
}
\usage{
data(B2)
}
\description{
List for yeast genes which are \bold{most} likely to be periodic 
(the benchmark set 2 in de Lichtenberg et al. (2005)).
}
\details{
Genes whose promoters were bound (P-value below 0.01) by at
least one of nine known cell cycle transcription factors in both
of the Chromatin IP studies by Simon et al. (2001) and Lee et al.
(2002). To obtain a benchmark set that is independent of B1, we
removed all genes included in B1 (50). The resulting benchmark
set, B2, consists of 352 genes of which many should be expected
to be cell cycle regulated, since their promoters are associated
with known stage-specific cell cycle transcription factors.
}
\examples{
data(alpha)
data(B2)
alphaB2 <- alpha[rownames(alpha)  \\\%in\\\% B2,]

}
\references{
De Lichtenberg, U., Jensen, L. J., Fausboll, A., 
Jensen, T. S., Bork, P.,& Brunak, S. (2005). 
Comparison of computational methods for the identification 
of cell cycle-regulated genes. Bioinformatics, 21(7), 1164-1171.
}
\keyword{datasets}

