% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/go.R
\name{gorilla}
\alias{gorilla}
\title{GO Enrichment Analysis}
\usage{
gorilla(target, background = NULL, mode = 'mhg', db = 'proc', pv = 0.001, spe = NULL)
}
\arguments{
\item{target}{path to the txt file containing (one per line) the UniProt id of the proteins belonging to the target set.}

\item{background}{path to the txt file containing (one per line) the UniProt id of the proteins belonging to the background set.}

\item{mode}{a character string specifying the desired analysis mode; it must be one of 'mhg' (identifies enriched GO terms in ranked lists), 'hg' (identifies enriched GO terms in the target set compared to the background set)}

\item{db}{a character string specifying the chosen ontology; it must be one of 'proc' (biological process), 'func' (molecular function), 'comp' (cellular component), 'all' (all the three previous ontologies).}

\item{pv}{a numeric value for the p-value threshold. Only GO terms with a p-value better than this threshold are reported.}

\item{spe}{a character string specifying the organism of interest. The species supported by GOrilla are: (Arabidopsis thaliana, Saccharomyces cerevisiae, Caenorhabditis elegans, Drosophila melanogaster, Danio rerio, Homo sapiens, Mus musculus, Rattus norvegicus)}
}
\value{
Returns either a dataframe with the enrichment results if a single ontology has been selected, or a list with three dataframe if the three ontologies were selected.
}
\description{
Performs GO terms enrichment analyses.
}
\details{
This function is a client of GOrilla, which is a web-based application that identifies enriched GO terms.
}
\examples{
\dontrun{gorilla(target = './go/GOvivo.txt', db = 'all')}
}
\references{
Eden et al. (2009) BMC Bioinformatics 10:48.

Rhee et al. (2008) Nature Reviews Genetics 9:509–515.
}
\seealso{
search.go(), term.go(), get.go(), bg.go(), net.go()
}
\author{
Juan Carlos Aledo
}
