% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolutionary.R
\name{msa}
\alias{msa}
\title{Multiple Sequence Alignment}
\usage{
msa(sequences, ids = names(sequences), sfile = FALSE, inhouse = FALSE)
}
\arguments{
\item{sequences}{vector containing the sequences.}

\item{ids}{vector containing the sequences' ids.}

\item{sfile}{if different to FALSE, then it should be a string indicating the path to save  a fasta alignment file.}

\item{inhouse}{logical, if TRUE the in-house MUSCLE software is used. It must be installed on your system and in the search path for executables.}
}
\value{
Returns a list of four elements. The first one ($seq) provides the sequences analyzed, the second element ($ids) returns the identifiers, the third element ($aln) provides the alignment in fasta format and the fourth element ($ali) gives the alignment in matrix format.
}
\description{
Aligns multiple protein sequences.
}
\examples{
\dontrun{msa(sequences = sapply(c("P19446", "P40925", "P40926"), ptm::get.seq),
 ids = c("wmelon", "cyt", "mit"))}
}
\references{
Edgar RC. Nucl. Ac. Res. 2004 32:1792-1797.

Edgar RC. BMC Bioinformatics 5(1):113.
}
\seealso{
custom.aln(), list.hom(), parse.hssp(), get.hssp(), shannon()
}
