% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\name{loglik.pt.1re}
\alias{loglik.pt.1re}
\title{Loglikelihood of Poisson-Tweedie generalized linear mixed model with random intercept}
\usage{
loglik.pt.1re(beta, D, a, Sigma, y, X, Z, id, offset = NULL, GHk = 5,
  tol = 9.88131291682493e-324, GHs = NULL)
}
\arguments{
\item{beta}{Vector of regression coefficients}

\item{D}{Dispersion parameter (must be > 1)}

\item{a}{Power parameter (must be < 1)}

\item{Sigma}{A matrix with the variance of the random intercept}

\item{y}{Response vector (discrete)}

\item{X}{Design matrix for the fixed effects}

\item{Z}{Design matrix for the random effects}

\item{id}{Id indicator (it should be numeric)}

\item{offset}{Offset term to be added to the linear predictor}

\item{GHk}{Number of quadrature points (default is 5)}

\item{tol}{Tolerance value for the evaluation of the probability mass function of the Poisson-Tweedie distribution}

\item{GHs}{Quadrature points at which to evaluate the loglikelihood. If \code{NULL} (default value), 
the GH quadrature points are computed internally}
}
\value{
The loglikelihood value obtained using a Gauss-Hermite quadrature
approximation with \code{GHk} quadrature points.
}
\description{
Evaluates the loglikelihood of a Poisson-Tweedie generalized linear mixed model 
with random intercept, using the adaptive Gauss-Hermite quadrature rule.
}
\references{
Signorelli, M., Spitali, P., Tsonaka, R. (2021). Poisson-Tweedie 
mixed-effects model: a flexible approach for the analysis of longitudinal RNA-seq
data. Statistical Modelling, 21 (6), 520-545. URL: https://doi.org/10.1177/1471082X20936017
}
\seealso{
\code{\link{ptmixed}} and the examples therein
}
\author{
Mirko Signorelli
}
