% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{mhor}
\alias{mhor}
\title{Mantel-Haenszel odds ratio.}
\usage{
mhor(formula, data)
}
\arguments{
\item{formula}{A formula expressed as outcome ~ stratum/exposure.}

\item{data}{A data frame containing the variables used in \code{formula}.}
}
\value{
Odds ratios with 95% confidence intervals on the effect of \code{exposure} on
  \code{outcome} by levels of \code{stratum}. The Mantel-Haenszel pooled OR and the test
  for effect modification is also reported.
}
\description{
\code{mhor} computes odds ratios by levels of the stratum variable as well as the Mantel-Haenszel
pooled odds ratio. The test for effect modification (test for interaction) is also displayed.
}
\examples{
data(oswego, package = "epitools")
oswego$ill <- factor(oswego$ill)
oswego$sex <- factor(oswego$sex)
oswego$chocolate.ice.cream <- factor(oswego$chocolate.ice.cream)
mhor(ill ~ sex/chocolate.ice.cream, data = oswego)
}
\seealso{
\link{mh}
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
