% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{strip_error}
\alias{strip_error}
\title{Strip plots with error bars.}
\usage{
strip_error(formula, data, pch = 20, aspect = 3/4, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x} or \code{y ~ x|z} where \code{y} is a
numerical variable and both \code{x} and \code{z} are factors.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{pch}{Point character passed to \link{stripplot}.}

\item{aspect}{Physical aspect ratio passed to \link{stripplot}.}

\item{...}{Further arguments passed to \link{stripplot}.}
}
\description{
\code{strip_error} constructs strip plots in \code{lattice} with error bars showing 95% bootstrapped
confidence intervals around mean values.
}
\examples{
data(energy, package="ISwR")
strip_error(expend ~ stature, data = energy, xlab = "Stature", ylab = "Energy expenditure (MJ)")

## Adding an horizontal line to show significant difference:
fig <- strip_error(expend~stature, data=energy, xlab="Stature",
                   ylab="Energy expenditure (MJ)", ylim=c(5.5,14))
fig + layer(panel.segments(1, 13.3, 2, 13.3, lwd=1.5)) + layer(panel.text(1.5, 13.5, "*"))

data(birthwt, package = "MASS")
birthwt$smoke <- factor(birthwt$smoke, labels = c("Non-smoker", "Smoker"))
birthwt$Race <- factor(birthwt$race > 1, labels = c("White", "Non-white"))
strip_error(bwt ~ Race|smoke, data = birthwt, ylab = "Birth weight (g)")
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
