% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{bar_error}
\alias{bar_error}
\title{Bar charts with error bars.}
\usage{
bar_error(formula, data, col = "gray70", aspect = 3/4, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x} or \code{y ~ x|z} where \code{y} is a
numerical variable and both \code{x} and \code{z} are factors.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{col}{Colour passed to \link{barchart}.}

\item{aspect}{Physical aspect ratio passed to \link{barchart}.}

\item{...}{Further arguments passed to \link{barchart}.}
}
\description{
\code{bar_error} constructs bar charts in \code{lattice} with error bars showing 95% bootstrapped
confidence intervals around mean values. High of bars represent mean values.
}
\details{
Limits for the y-axis have to be estimated; lower limit should be zero and upper limit higher than
the maximum upper confidence interval.
}
\examples{
data(birthwt, package = "MASS")
birthwt$smoke <- factor(birthwt$smoke, labels = c("Non-smoker", "Smoker"))
gen_bst_df(bwt ~ smoke, data = birthwt) # To estimate limits of y-axis.
bar_error(bwt ~ smoke, data = birthwt, ylab = "Birth weight (g)", ylim = c(0, 3500))

birthwt$race <- factor(birthwt$race, labels = c("White", "African American", "Other"))
gen_bst_df(bwt ~ race|smoke, data = birthwt) # To estimate limits of y-axis.
bar_error(bwt ~ race|smoke, data = birthwt, ylab = "Birth weight (g)", ylim = c(0, 3800))

bar_error(bwt ~ race|smoke, data = birthwt, ylab = "Birth weight (g)", ylim = c(0, 3800),
          col = c("gray95", "gray20", "gray50"))
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
