% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Brenner}
\alias{Brenner}
\title{Prevalence of Helicobacter pylori infection in preschool children.}
\format{A labelled tibble with 863 rows and 2 variables:
\describe{
\item{Ulcer}{History of duodenal or gastric ulcer, factor with levels "No" and "Yes".}
\item{Infected}{Infected with Helicobacter pylori, factor with levels "No" and "Yes".}
}}
\source{
Brenner H, Rothenbacher D, Bode G, Adler G (1998) Parental history of gastric or duodenal ulcer
and prevalence of Helicobacter pylori infection in preschool children: population based study.
BMJ 316:665.
}
\usage{
Brenner
}
\description{
A data set containing the prevalence of Helicobacter pylori infection in preschool children
according to parental history of duodenal or gastric ulcer.
}
\examples{
data(Brenner)
require(moonBook)

mytable(Infected ~ Ulcer, data = Brenner, show.total =TRUE)

contingency(Infected ~ Ulcer, data = Brenner, method = "cross.sectional")
}
\keyword{datasets}
