% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{cross_tab}
\alias{cross_tab}
\title{Cross-tabulation.}
\usage{
cross_tab(
  object = NULL,
  formula = NULL,
  data = NULL,
  label = NULL,
  show.total = TRUE,
  p_val = FALSE,
  pad = 3,
  width = 0.8,
  method = 1,
  ...
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: \code{y ~ x}, where \code{y} is a categorical outcome and \code{x} is the explanatory variable or a set of explanatory variables (see Details and Examples).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{label}{A character, label to be used for the outcome (for non-labelled data).}

\item{show.total}{Logical, show column with totals?}

\item{p_val}{Logical, show p-values?}

\item{pad}{Numerical, padding above and bellow rows.}

\item{width}{Numerical, proportional width of the table.}

\item{method}{An integer indicating methods for continuous variables.
1 Reports means and standard deviations.
2 Reports medians and interquartile ranges.}

\item{...}{Additional arguments passed to \code{\link[moonBook]{mytable_sub}}.}
}
\value{
A huxtable with descriptive statistics stratified by levels of the outcome.
}
\description{
\code{cross_tab} is a wrapper to functions from package \code{moonBook} to construct tables of descriptive statistics stratified by levels of a categorical outcome.
}
\details{
Function \code{cross_tab} is a relatively simple wrapper to function \code{mytable} of package \code{moonBook}. Its main purpose is to construct contingency tables but it can also be used to report a table with descriptives for all variables as long as they are still stratified by the outcome. Please see examples to see how to list explanatory variables. For categorical explanatory variables, the function reports column percentages. If data is labelled with \code{sjlabelled}, the label of the outcome (dependent) variable is used to name the outcome; this name can be changed with argument \code{label}.
}
\seealso{
\code{\link[moonBook]{mytable}}
}
