% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{op}
\alias{op}
\title{Opportunity of purging}
\usage{
op(ped, pi, Fi, name_O, name_Oe, compute_O = FALSE, complex = TRUE)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{pi}{Partial inbreeding matrix}

\item{Fi}{Vector of inbreeding coefficient values}

\item{name_O}{A string naming the new output column for total opportunity of purging (defaults to "O")}

\item{name_Oe}{A string naming the new output column for the expressed opportunity of purging (defaults to "Oe")}

\item{compute_O}{Enable computation of total opportunity of purging (false by default)}

\item{complex}{Enable correction for complex pedigrees.}
}
\value{
The input dataframe, plus two additional column named "O" and "Oe", containing total and expressed opportunity of purging measures.
}
\description{
The potential reduction in individual inbreeding load can be
estimated by means of the opportunity of purging (\emph{O}) and expressed
opportunity of purging (\emph{Oe}) parameters described by Gulisija
and Crow (2007). Whereas \emph{O} relates to the total potential reduction
of the inbreeding load in an individual, as a consequence of it having
inbred ancestors, \emph{Oe} relates to the expressed potential reduction of the
inbreeding load. In both cases, these measures are referred to fully recessive,
high effect size alleles (e.g. lethals). For complex pedigrees, involving more than one
autozygous individual per path from a reference individual to an
ancestor, these estimates are estimated following an heuristic approach
(see details below).
}
\details{
In simple pedigrees, the opportunity of purging (\emph{O}) and the expressed
opportunity of purging (\emph{Oe}) are estimated as in Gulisija and Crow (2007).
For complex pedigrees involving more than one autozygous individual per
path from an individual to an ancestor, \emph{O} and \emph{Oe} in the closer ancestors
need to be discounted for what was already accounted for in their predecessors.
To solve this problem, Gulisija and Crow (2007) provide expression to 
correct \emph{O} and \emph{Oe} (see equations 21 and 22 in the manuscript).

Here, an heuristic approach is used to prevent the inflation of \emph{O} and \emph{Oe},
and avoid the use of additional looped expressions that may result in an
excessive computational cost. To do so, when using \code{ip_op(complex = TRUE)}
only the contribution of the most recent ancestors in a path will be considered.
This may not provide exact values of \emph{O} and \emph{Oe}, but we expect little bias, since
more distant ancestors also contribute lesser to \emph{O} and \emph{Oe}.
}
\references{
\itemize{
  \item{Gulisija D, Crow JF. 2007. Inferring purging from pedigree data. Evolution 61(5): 1043-1051.}
}
}
