% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/map.R
\name{map2}
\alias{map2}
\alias{map3}
\alias{map_n}
\alias{walk2}
\alias{walk3}
\alias{walk_n}
\title{Map over multiple inputs simultaneously.}
\usage{
map2(.x, .y, .f, ...)

map3(.x, .y, .z, .f, ...)

map_n(.l, .f, ...)

walk2(.x, .y, .f, ...)

walk3(.x, .y, .z, .f, ...)

walk_n(.l, .f, ...)
}
\arguments{
\item{.x,.y,.z}{Lists of the same length or of length 1. Only
lists of length 1 are recycled.}

\item{.f}{A function of two (for \code{map2} and \code{walk2}) or
three (\code{map3} and \code{walk3}) arguments. For \code{map_n}
and \code{walk_n}, the number of arguments must correspond to the
number of elements of \code{.l}.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.l}{A list of lists to be mapped on simultaneously.}
}
\description{
These functions are designed in such a way that arguments to be
vectorised over come before the function name, and arguments that
should be supplied to every call come after the function name.
}
\details{
\code{map_n()} and \code{walk_n()} take a single list \code{.l} and
map over all its elements simultaneously. \code{map2()} and
\code{map3()} return a data frame when \code{.x} is a data frame.
}
\examples{
x <- list(1, 10, 100)
y <- list(1, 2, 3)
map2(x, y, ~ .x + .y)
# Or just
map2(x, y, `+`)

z <- list(15, 20, 25)
map3(x, y, z, ~ .x ^ .y + .z)

# Split into pieces, fit model to each piece, then predict
by_cyl <- mtcars \%>\% split(.$cyl)
mods <- by_cyl \%>\% map(~ lm(mpg ~ wt, data = .))
map2(mods, by_cyl, predict)
}

