% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map2}
\alias{map2}
\alias{map2_chr}
\alias{map2_dbl}
\alias{map2_df}
\alias{map2_int}
\alias{map2_lgl}
\alias{map3}
\alias{map_n}
\alias{pmap}
\alias{pmap_chr}
\alias{pmap_dbl}
\alias{pmap_df}
\alias{pmap_int}
\alias{pmap_lgl}
\alias{pwalk}
\alias{walk2}
\alias{walk3}
\alias{walk_n}
\title{Map over multiple inputs simultaneously.}
\usage{
map2(.x, .y, .f, ...)

map2_lgl(.x, .y, .f, ...)

map2_int(.x, .y, .f, ...)

map2_dbl(.x, .y, .f, ...)

map2_chr(.x, .y, .f, ...)

map2_df(.x, .y, .f, ..., .id = NULL)

pmap(.l, .f, ...)

pmap_lgl(.l, .f, ...)

pmap_int(.l, .f, ...)

pmap_dbl(.l, .f, ...)

pmap_chr(.l, .f, ...)

pmap_df(.l, .f, ..., .id = NULL)

walk2(.x, .y, .f, ...)

pwalk(.l, .f, ...)
}
\arguments{
\item{.x, .y}{Vectors of the same length. A vector of length 1 will
be recycled.}

\item{.f}{A function, formula, or atomic vector.

  If a \strong{function}, it is used as is.

  If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a
  function with two arguments, \code{.x} or \code{.} and \code{.y}. This
  allows you to create very compact anonymous functions with up to
  two inputs.

  If \strong{character} or \strong{integer vector}, e.g. \code{"y"}, it
  is converted to an extractor function, \code{function(x) x[["y"]]}. To
  index deeply into a nested list, use multiple values; \code{c("x", "y")}
  is equivalent to \code{z[["x"]][["y"]]}. You can also set \code{.null}
  to set a default to use instead of \code{NULL} for absent components.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.id}{If not \code{NULL} a variable with this name will be created
giving either the name or the index of the data frame.}

\item{.l}{A list of lists. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\value{
An atomic vector, list, or data frame, depending on the suffix.
  Atomic vectors and lists will be named if \code{.x} or the first
  element of \code{.l} is named.
}
\description{
These functions are variants of \code{map()} iterate over multiple
arguments in parallel. \code{map2} is specialised for the two argument
case; \code{pmap} allows you to provide any number of arguments in a
list.
}
\details{
Note that arguments to be vectorised over come before the \code{.f},
and arguments that are supplied to every call come after \code{.f}.

\code{pmap()} and \code{pwalk()} take a single list \code{.l} and
map over all its elements in parallel.
}
\examples{
x <- list(1, 10, 100)
y <- list(1, 2, 3)
map2(x, y, ~ .x + .y)
# Or just
map2(x, y, `+`)

# Split into pieces, fit model to each piece, then predict
by_cyl <- mtcars \%>\% split(.$cyl)
mods <- by_cyl \%>\% map(~ lm(mpg ~ wt, data = .))
map2(mods, by_cyl, predict)
}

