% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map}
\alias{map}
\alias{map_lgl}
\alias{map_chr}
\alias{map_int}
\alias{map_dbl}
\alias{map_df}
\alias{walk}
\title{Apply a function to each element of a vector}
\usage{
map(.x, .f, ...)

map_lgl(.x, .f, ...)

map_chr(.x, .f, ...)

map_int(.x, .f, ...)

map_dbl(.x, .f, ...)

map_df(.x, .f, ..., .id = NULL)

walk(.x, .f, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or atomic vector.

  If a \strong{function}, it is used as is.

  If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a
  function with two arguments, \code{.x} or \code{.} and \code{.y}. This
  allows you to create very compact anonymous functions with up to
  two inputs.

  If \strong{character} or \strong{integer vector}, e.g. \code{"y"}, it
  is converted to an extractor function, \code{function(x) x[["y"]]}. To
  index deeply into a nested list, use multiple values; \code{c("x", "y")}
  is equivalent to \code{z[["x"]][["y"]]}. You can also set \code{.null}
  to set a default to use instead of \code{NULL} for absent components.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.id}{If not \code{NULL} a variable with this name will be created
giving either the name or the index of the data frame.}
}
\value{
\code{map()} always returns a list.

  \code{map_lgl()} returns a logical vector, \code{map_int()} an integer
  vector, \code{map_dbl()}, a double vector, \code{map_chr()}, a character
  vector. The output of \code{.f} will be automatically typed upwards,
  e.g. logical -> integer -> double -> character.

  \code{walk()} (invisibly) the input \code{.x}. It's called primarily for
  its side effects, but this makes it easier to combine in a pipe.
}
\description{
\code{map()} returns the transformed input; \code{walk()} calls
\code{.f} for its side-effect and returns the original
input. \code{map()} returns a list or a data frame; \code{map_lgl()},
\code{map_int()}, \code{map_dbl()} and \code{map_chr()} return vectors
of the corresponding type (or die trying); \code{map_df()} returns
a data frame by row-binding the individual elements.
}
\details{
Note that \code{map()} understands data frames, including grouped
data frames. It can be much faster than
\code{\link[dplyr:summarise_each]{mutate_each()}} when your data frame has many
columns. However, \code{map()} will be slower for the more common case of many
groups with functions that dplyr knows how to translate to C++.
}
\examples{
1:10 \%>\%
  map(rnorm, n = 10) \%>\%
  map_dbl(mean)

# Or use an anonymous function
1:10 \%>\%
  map(function(x) rnorm(10, x))

# Or a formula
1:10 \%>\%
  map(~ rnorm(10, .x))

# A more realistic example: split a data frame into pieces, fit a
# model to each piece, summarise and extract R^2
mtcars \%>\%
  split(.$cyl) \%>\%
  map(~ lm(mpg ~ wt, data = .x)) \%>\%
  map(summary) \%>\%
  map_dbl("r.squared")

# Use map_lgl(), map_dbl(), etc to reduce to a vector.
# * list
mtcars \%>\% map(sum)
# * vector
mtcars \%>\% map_dbl(sum)

# If each element of the output is a data frame, use
# map_df to row-bind them together:
mtcars \%>\%
  split(.$cyl) \%>\%
  map(~ lm(mpg ~ wt, data = .x)) \%>\%
  map_df(~ as.data.frame(t(as.matrix(coef(.)))))
# (if you also want to preserve the variable names see
# the broom package)
}
\seealso{
\code{\link{map2}()} and \code{\link{pmap}()} to map over multiple
  inputs simulatenously
}
