% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvlrt-wrappers.R
\name{lrt_poisson}
\alias{lrt_poisson}
\alias{lrt_vanilla_poisson}
\title{Likelihood Ratio Test under the (vanilla, non-zero-inflated) Poisson model}
\usage{
lrt_poisson(contin_table, nsim = 10000, parametrization = "rrr", ...)

lrt_vanilla_poisson(contin_table, nsim = 10000, parametrization = "rrr", ...)
}
\arguments{
\item{contin_table}{IxJ contingency table showing pairwise counts of adverse
effects for I AE and J Drugs}

\item{nsim}{Number of simulated null contingency table to use for computing
the p-value of the test}

\item{parametrization}{Type of parametrization to use in the LR test. Available choices are "rrr", "lambda", "rr",
and "p-q". The relative reporting ratio (default) parametrization of the test is used when
when \code{parametrization \%in\% c("rrr", "lambda")}, and the reporting rate parametrization is used
otherwise. NOTE: zero inflation can be handled only for the relative reporting ratio parametrization.}

\item{...}{additional arguments. Currently unused.}
}
\value{
Returns a \code{pvlrt} object. See \link{pvlrt} for more details.
}
\description{
Likelihood Ratio Test under the (vanilla, non-zero-inflated) Poisson model
}
\note{
\code{lrt_poisson()} and \code{lrt_vanilla_poisson()}
are both wrappers for \code{pvlrt()} with
\code{omega_vec = rep(0, ncol(contin_table))}
}
\examples{

data("statin46")

# 500 bootstrap iterations (nsim) in the example below
# are for quick demonstration only --
# we recommended setting nsim to 10000 (default) or bigger

# no grouping -- each drug forms its own class
test1 <- lrt_poisson(lovastatin, nsim = 500)


}
\seealso{
\link{pvlrt}
}
