% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_level_disprop_analysis.R
\name{add_expected_counts}
\alias{add_expected_counts}
\title{Produces expected counts}
\usage{
add_expected_counts(
  df = NULL,
  df_colnames = NULL,
  df_syms = NULL,
  expected_count_estimators = c("rrr", "prr", "ror")
)
}
\arguments{
\item{df}{An object possible to convert to a data table, e.g.
a tibble or data.frame, containing patient level reported drug-event-pairs.
See header 'The df object' below for further details.}

\item{df_colnames}{A list of column names to use in \code{df}. That is,
point \code{da} to the 'report id'-column (\code{report_id}), the
'drug name'-column (\code{drug}), the 'adverse event'-column (\code{event})
and optionally a grouping column \code{group_by} to calculate disproportionality
across. See the vignette for further details.}

\item{df_syms}{A list built from df_colnames through conversion to symbols.}

\item{expected_count_estimators}{A character vector containing the desired
expected count estimators. Defaults to c("rrr", "prr", "ror").}
}
\value{
A tibble containing the various counts.
}
\description{
Produces various counts used in disproportionality analysis.
}
\section{The df object}{

 The passed \code{df} should be (convertible to) a data table and at least contain three
 columns: \code{report_id}, \code{drug} and \code{event}. The data table should contain one row
 per reported drug-event-combination, i.e. receiving a single additional report
 for drug X and event Y would add one row to the table. If the single report
 contained drug X for event Y and event Z, two rows would be added, with the
 same \code{report_id} and \code{drug} on both rows. Column \code{report_id} must be of type
 numeric or character. Columns \code{drug} and \code{event} must be of type character.
 If column \code{group_by} is provided, it can be either numeric or character.
 You can use a \code{df} with column names of your choosing, as long as you
 connect role and name in the \code{df_colnames}-parameter.
}

