\name{Votes.getBillsByStateRecent}
\alias{Votes.getBillsByStateRecent}
\title{Get a list of recent bills according to the state.}
\usage{
  Votes.getBillsByStateRecent(amount, state="NA")
}
\arguments{
  \item{amount}{(optional) the amount of bills returned
  (default: 100, max: 100)}

  \item{state}{(optional) a character string or list of
  character strings with the state(s) (default: NA) (see
  references for details)}
}
\value{
  A data frame with a row for each bill and columns with
  variables describing the bill. The returned data frame
  contains a row for each bill and columns with the
  following variables describing the bill:\cr
  bills.bill*.billId,\cr bills.bill*.billNumber,\cr
  bills.bill*.title,\cr bills.bill*.type.
}
\description{
  This function is a wrapper for the
  Votes.getBillsByStateRecent() method of the PVS API Votes
  class which returns a list of recent bills according to
  the state. The maximum number of bills returned is 100.
  The function sends a request with this method to the PVS
  API for all states given as a function input, extracts
  the XML values from the returned XML file(s) and returns
  them arranged in one data frame.
}
\examples{
# First, make sure your personal PVS API key is saved as character string in the pvs.key variable:
\dontrun{pvs.key <- "yourkey"}
# get a list of recent bills according to the state
\dontrun{recentbills <- Votes.getBillsByStateRecent(40,list("FL","NY"))}
\dontrun{recentbills}
}
\author{
  Ulrich Matter <ulrich.matter-at-unibas.ch>
}
\references{
  http://api.votesmart.org/docs/Votes.html\cr Use
  State.getStateIDs() to get a list of state IDs.
}

