\name{Rating.getRating}
\alias{Rating.getRating}
\title{Get all candidate ratings from an evaluation by a special interest group}
\usage{
Rating.getRating(ratingId)
}
\arguments{
  \item{ratingId}{a character string or list of character
  strings with the rating ID(s) (see references for
  details)}
}
\value{
A data frame with a row for each candidate and columns with
the following variables describing the candidate:\cr
candidateRating*.candidateId,\cr candidateRating*.rating.
}
\description{
This function is a wrapper for the Rating.getRating()
method of the PVS API Rating class which dumps all
candidate ratings from a scorecard by a special interest
group (SIG). The function sends a request with this method
to the PVS API for all rating IDs given as a function
input, extracts the XML values from the returned XML
file(s) and returns them arranged in one data frame.
}
\examples{
# First, make sure your personal PVS API key is saved as character string in the pvs.key variable:
\dontrun{pvs.key <- "yourkey"}
# get the candidate rating by a certain special interest group
\dontrun{scorecard <- Rating.getRating(77)}
\dontrun{scorecard}
}
\author{
Ulrich Matter <ulrich.matter-at-unibas.ch>
}
\references{
http://api.votesmart.org/docs/Rating.html\cr Use
Rating.getSigRatings() or Rating.getCandidateRating() to
get a list of rating IDs.
}

