% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iGWAS.R
\name{iGWAS}
\alias{iGWAS}
\title{informed Genome-Wide Association Study}
\usage{
iGWAS(P_current, N_current, P_prior, N_prior, q = 0.05,
  weighting_method = "bayes", p_adjust_method = "genome-wide", sides = 2,
  phi = 1, beta = 2, UB_exp = Inf, figure = "FALSE",
  GWAS_data_frame = NA)
}
\arguments{
\item{P_current}{P-values in the current study, a numeric vector of length J, with entries between 0 and 1}

\item{N_current}{sample size in the current study, a positive integer (or vector of length J)}

\item{P_prior}{P-values in the prior study, a numeric vector of length J, with entries between 0 and 1}

\item{N_prior}{sample size in the current study, a positive integer (or vector of length J)}

\item{q}{(optional) uncorrected level at which tests should be performed. Default \code{q = 0.05}}

\item{weighting_method}{(optional) weighting method used. Available methods: \code{c("unweighted",
"bayes", "spjotvoll", "exponential")}. The default is \code{"bayes"}.}

\item{p_adjust_method}{(optional) adjustment method for multiple testing used. The available methods are
\code{"genome-wide"} and those from the \code{p.adjust} function in the \code{stats} package.:
\code{c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY",  "fdr", "none")}.
\code{"genome-wide"} tests all hypotheses at the genome-wide level \code{5*10^-8}.
The default is \code{"genome-wide"}.}

\item{sides}{(optional) The prior p-values must be one or two-sided: sides = 1 or 2. Default \code{sides = 2}}

\item{phi}{(optional) dispersion factor used to multiply all standard errors. Default \code{phi = 1}.
Used only for Bayes weights.}

\item{beta}{(optional) weights are proportional to \code{exp(mu*beta)}, default \code{beta=2}.
Used only for Exponential weights.}

\item{UB_exp}{(optional) upper bound on the weights (default \code{UB = Inf}).
Used only for Exponential weights.}

\item{figure}{(optional) \code{figure = "TRUE"} creates a manhattan plot of the weighted and unweighted p-values.
Possible values \code{c("TRUE","FALSE")}, default \code{"FALSE"}}

\item{GWAS_data_frame}{(optional) when \code{figure = "TRUE"}, this is the parameter used to create a
Manattan plot. it must be a data frame with columns containing \code{c("CHR","BP")}.
These parameters are passed to the qqman package for plotting manhattan plots. Default is NA.}
}
\value{
A list containing:

\code{sig_ind}: A vector of 0-1s indicating the significant tests (1-s)

\code{num_sig}: The number of significant tests. Equals \code{sum(sig_ind)}

\code{w}: The computed p-value weights

\code{P_w}: The weighted p-values. These equal \code{P_current/w}
}
\description{
Perform an informed Genome-Wide Association Study (iGWAS). This is based on a current study and a prior study. The goal is to discover significant SNPs in the current study using hypothesis testing. The prior study is used to improve power. P-values and sample sizes are used for both the current and the prior studies.
}
\details{
This method computes the p-value weights based on the prior p-values, and uses them in multiple testing (p-value weighting) for the current p-values.  The p-value weighting method (e.g. Unweighted, Bayes) and the multiple testing adjustment (e.g. Bonferroni, Benjamini-Hochberg) can be specified independently.

For more details, see the paper "Optimal Multiple Testing Under a
 Gaussian Prior on the Effect Sizes", by Dobriban, Fortney, Kim and Owen,
  \url{http://arxiv.org/abs/1504.02935}
}
\seealso{
Other p.value.weighting: \code{\link{bayes_weights}};
  \code{\link{exp_weights}};
  \code{\link{spjotvoll_weights}}
}

