% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmlmm.R
\name{wmlmm}
\alias{wmlmm}
\title{Fit Weighted Multivariate Linear Multilevel Model to Longitudinal Data.}
\usage{
wmlmm(formula, data = NULL, ID3, ID2, ID1, wj, wij, type, rot = NULL)
}
\arguments{
\item{formula}{a linear formula object with the response on the left of a ~ operator and the terms, separated by + operators, on the right.}

\item{data}{an optional data frame containing the variables in \code{formula}. If not found in data, the variables are taken from the environment of \code{formula} (if specified as a formula) or from the parent frame (if specified as a character vector).}

\item{ID3}{vector of indexes for level two units}

\item{ID2}{vector of indexes for level one units.}

\item{ID1}{vector of successive measurements within the same level one unit, for all units.}

\item{wj}{a vector of sampling weights for level two units. Level two units are selected with inclusion probabilities. Then, sampling weights for the level two units are defined as the inverse of these probabilities.}

\item{wij}{a vector of sampling weights for level one units. After selecting a level two unit, level one units belonging to them are selected with inclusion probabilities. Then, sampling weights for the level one units are defined as the inverse of these probabilities.}

\item{type}{type of structure imposed in the error covariance matrix; "toep" refers to the toeplitz, "uns" refers to the unestructured and "genlin" refers to the general linear.}

\item{rot}{vector of 0's and 1's related to the measurements in time when \code{"genlin"} is passed to the \code{type} argument. Use 1 if the data were collected in that specific time unit, and 0 otherwise.}
}
\value{
Estimated list of estimators
}
\description{
Fit a two-level probability-weighted multivariate linear model with a linear error covariance matrix structure, via IGLS algorithm.
}
\details{
Follows estimation process described in Veiga et al. (2014). Uses probability-weighted IGLS with scaled weights.
}
\examples{
data(datamultv)
 wmlmm ( Y ~ X1 + X2, data = datamultv, PSU, idd, wave, wj, wi_j, "toep")

}
\references{
A. Veiga, P. W. F. Smith and J. J. Brown (2014),
The use of sample weights in multivariate multilevel models with an application to income data collected by using a rotating panel survey
Journal of the Royal Statistical Society. Series C (Applied Statistics)
Vol. 63, No. 1 (JANUARY 2014), pp. 65-84 (20 pages)
}
