% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRC_shortcuts.R
\name{MRC_shortcuts}
\alias{MRC_shortcuts}
\title{Compute Multiple Regression shortcuts with three predictors (will expand to handle two to five)
Requires correlations between all variables as sample size. Means and sds are option. Also computes Power(All)}
\usage{
MRC_shortcuts(
  ry1 = NULL,
  ry2 = NULL,
  ry3 = NULL,
  r12 = NULL,
  r13 = NULL,
  r23 = NULL,
  n = 100,
  alpha = 0.05,
  my = 0,
  m1 = 0,
  m2 = 0,
  m3 = 0,
  s1 = 1,
  s2 = 1,
  s3 = 1,
  sy = 1
)
}
\arguments{
\item{ry1}{Correlation between DV (y) and first predictor (1)}

\item{ry2}{Correlation between DV (y) and second predictor (2)}

\item{ry3}{Correlation between DV (y) and third predictor (3)}

\item{r12}{Correlation between first (1) and second predictor (2)}

\item{r13}{Correlation between first (1) and third predictor (3)}

\item{r23}{Correlation between second (2) and third predictor (3)}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{my}{Mean of DV (default is 0)}

\item{m1}{Mean of first predictor (default is 0)}

\item{m2}{Mean of second predictor (default is 0)}

\item{m3}{Mean of third predictor (default is 0)}

\item{s1}{Standard deviation of first predictor (default is 1)}

\item{s2}{Standard deviation of second predictor (default is 1)}

\item{s3}{Standard deviation of third predictor (default is 1)}

\item{sy}{Standard deviation of DV (default is 1)}
}
\value{
Multiple Regression shortcuts with three predictors
}
\description{
Compute Multiple Regression shortcuts with three predictors (will expand to handle two to five)
Requires correlations between all variables as sample size. Means and sds are option. Also computes Power(All)
}
\examples{
MRC_shortcuts(ry1=.40,ry2=.40,ry3=-.40, r12=-.15, r13=-.60,r23=.25,
n=110, my=1,m1=1,m2=1,m3=1,sy=7,s1=1,s2=1,s3=2)
}
