% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medjs_paths.R
\name{medjs_paths}
\alias{medjs_paths}
\title{Compute Power for Mediated (Indirect) Effects Using Joint Significance
Requires paths for all effects (and if 2 mediators, correlation)
Standard deviations/variances set to 1.0 so paths are technically standardized}
\usage{
medjs_paths(
  a1,
  a2 = NULL,
  b1,
  b2 = NULL,
  rm1m2 = NULL,
  cprime,
  n,
  alpha = 0.05,
  mvars,
  rep = 1000
)
}
\arguments{
\item{a1}{path between predictor and first mediator}

\item{a2}{path between predictor and first mediator}

\item{b1}{Path between first mediator and dependent variable}

\item{b2}{Path between first mediator and dependent variable}

\item{rm1m2}{Correlation first mediator (m1) and second mediator (m2)}

\item{cprime}{Path between predictor and dependent variable}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{mvars}{Number of Mediators}

\item{rep}{number of repetitions (1000 is default)}
}
\value{
Power for Mediated (Indirect) Effects using Paths Coefficients
}
\description{
Compute Power for Mediated (Indirect) Effects Using Joint Significance
Requires paths for all effects (and if 2 mediators, correlation)
Standard deviations/variances set to 1.0 so paths are technically standardized
}
\examples{
\donttest{medjs_paths(a1=.25, b1=-.5,cprime=.2,mvars=1, n=150)}
\donttest{medjs_paths(a1=.25, a2=.1, b1=-.5,b2=-.2,cprime=.2,mvars=1, n=150)}
}
