% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova2x2_se.R
\name{anova2x2_se}
\alias{anova2x2_se}
\title{Compute power for Simple Effects in a Two by Two Between Subjects ANOVA with two levels for each factor.
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
anova2x2_se(
  m1.1 = NULL,
  m1.2 = NULL,
  m2.1 = NULL,
  m2.2 = NULL,
  s1.1 = NULL,
  s1.2 = NULL,
  s2.1 = NULL,
  s2.2 = NULL,
  n1.1 = NULL,
  n1.2 = NULL,
  n2.1 = NULL,
  n2.2 = NULL,
  alpha = 0.05
)
}
\arguments{
\item{m1.1}{Cell mean for First level of Factor A, First level of Factor B}

\item{m1.2}{Cell mean for First level of Factor A, Second level of Factor B}

\item{m2.1}{Cell mean for Second level of Factor A, First level of Factor B}

\item{m2.2}{Cell mean for Second level of Factor A, Second level of Factor B}

\item{s1.1}{Cell standard deviation for First level of Factor A, First level of Factor B}

\item{s1.2}{Cell standard deviation for First level of Factor A, Second level of Factor B}

\item{s2.1}{Cell standard deviation for Second level of Factor A, First level of Factor B}

\item{s2.2}{Cell standard deviation for Second level of Factor A, Second level of Factor B}

\item{n1.1}{Cell sample size for First level of Factor A, First level of Factor B}

\item{n1.2}{Cell sample size for First level of Factor A, Second level of Factor B}

\item{n2.1}{Cell sample size for Second level of Factor A, First level of Factor B}

\item{n2.2}{Cell sample size for Second level of Factor A, Second level of Factor B}

\item{alpha}{Type I error (default is .05)
examples
anova2x2_se(m1.1=0.85, m1.2=0.85, m2.1=0.00, m2.2=0.60,
s1.1=1.7, s1.2=1.7, s2.1=1.7, s2.2=1.7,
n1.1=250, n1.2=250, n2.1=250, n2.2=250, alpha=.05)}
}
\value{
Power for Simple Effects Tests in a Two By Two ANOVA
}
\description{
Compute power for Simple Effects in a Two by Two Between Subjects ANOVA with two levels for each factor.
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
}
