% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_df.R
\name{df.spd}
\alias{df.spd}
\title{Create data frame for split-plot design}
\usage{
df.spd(trt.main, trt.sub, label, replicates)
}
\arguments{
\item{trt.main}{an integer-valued vector specifying the treatment structure at
main plot level, similar to \code{\link{df.crd}}.}

\item{trt.sub}{an integer-valued vector specifying the treatment structure at
sub plot level, similar to \code{trt.main}.}

\item{label}{Optional. A list of character vectors specifying the names of
treatment factors and factor levels. Each vector in the list represents a
treatment factor, where the name of the vector specifies the name of the
factor, and the values in the vector are the labels for that factor's levels.
If not provided, factors and levels for one and two treatment factors are
labeled as \code{list(trt = c("1", "2", ...))} and
\code{list(facA = c("1", "2", ...), facB = c("1", "2", ...))}, respectively.}

\item{replicates}{the number of experimental units (main plots) per treatment
of main plot factors.}
}
\value{
a data.frame with columns for main plots, main treatments, and sub-treatments
}
\description{
Create data frame for split-plot design
}
