% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_get.R
\name{pxweb_advanced_get}
\alias{pxweb_advanced_get}
\title{Do a GET call to PXWEB API for advanced users}
\usage{
pxweb_advanced_get(url, query = NULL, verbose = TRUE,
  log_http_calls = FALSE, pxmdo = NULL, ...)
}
\arguments{
\item{url}{a \code{pxweb} object or url that can be coherced to a \code{pxweb} object.}

\item{query}{a json string, json file or list object that can be coherced to a \code{pxweb_query} object.}

\item{verbose}{should large queries print out progress.}

\item{log_http_calls}{Should the http calls to the API be logged (for debugging reasons). 
If TRUE, all calls and responses are logged and written to "log_pxweb_api_http_calls.txt" in the working directory.}

\item{pxmdo}{A \code{pxweb_metadata} object to use for query.}

\item{...}{Further arguments sent to \code{httr::POST} (for queries) or \code{httr::GET} (for query = \code{NULL}). 
If used with query, also supply a \code{pxweb_metadata} object. Otherwise the same parameters are sent to
both \code{httr::POST} and \code{httr::GET}.}
}
\description{
Do a GET call to PXWEB API for advanced users
}
\details{
This function is intended for more advanced users that want to supply specific arguments in
\code{httr} calls or what to debug \code{httr} calls. 

\code{pxweb_get()} is a wrapper for standard use.
}
