% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchHITs.R
\name{SearchHITs}
\alias{SearchHITs}
\alias{searchhits}
\alias{ListHITs}
\alias{listhits}
\title{Search your HITs}
\usage{
SearchHITs(
  return.pages = NULL,
  results = as.integer(100),
  pagetoken = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{return.pages}{An integer indicating how many pages of results should
be returned.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A list containing data frames of HITs and Qualification Requirements
}
\description{
Search for your HITs and return those HITs as R objects.
}
\details{
Retrieve your current HITs (and, optionally, characteristics thereof).

\code{searchhits()}, \code{ListHITs()}, and \code{listhits()} are aliases
}
\examples{

\dontrun{
SearchHITs()
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html}{API
Reference}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{HITs}
