% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateQualificationType.R
\name{UpdateQualificationType}
\alias{UpdateQualificationType}
\alias{updatequal}
\title{Update a Worker QualificationType}
\usage{
UpdateQualificationType(
  qual,
  description = NULL,
  status = NULL,
  retry.delay = NULL,
  test = NULL,
  answerkey = NULL,
  test.duration = NULL,
  auto = NULL,
  auto.value = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE)
)
}
\arguments{
\item{qual}{A character string containing a QualificationTypeId.}

\item{description}{A longer description of the QualificationType. This is
visible to workers. Maximum of 2000 characters.}

\item{status}{A character vector of \dQuote{Active} or \dQuote{Inactive},
indicating whether the QualificationType should be active and visible.}

\item{retry.delay}{An optional time (in seconds) indicating how long workers
have to wait before requesting the QualificationType after an initial
rejection. If not specified, retries are disabled and Workers can request a
Qualification of this type only once, even if the Worker has not been
granted the Qualification.}

\item{test}{An optional character string consisting of a QuestionForm data
structure, used as a test a worker must complete before the
QualificationType is granted to them.}

\item{answerkey}{An optional character string consisting of an AnswerKey
data structure, used to automatically score the test}

\item{test.duration}{An optional time (in seconds) indicating how long
workers have to complete the test.}

\item{auto}{A logical indicating whether the Qualification is automatically
granted to workers who request it. Default is \code{NULL} meaning
\code{FALSE}.}

\item{auto.value}{An optional parameter specifying the value that is
automatically assigned to workers when they request it (if the Qualification
is automatically granted).}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the QualificationTypeId of the newly created
QualificationType and other details as specified in the request.
}
\description{
Update characteristics of a QualificationType.
}
\details{
A function to update the characteristics of a QualificationType. Name and
keywords cannot be modified after a QualificationType is created.

\code{updatequal()} is an alias.
}
\examples{

\dontrun{
qual1 <- CreateQualificationType(name="Worked for me before",
    description="This qualification is for people who have worked for me before",
    status = "Active",
    keywords="Worked for me before")
qual2 <- UpdateQualificationType(qual1$QualificationTypeId,
    description="This qualification is for everybody!",
    auto=TRUE, auto.value="5")
DisposeQualificationType(qual1$QualificationTypeId)
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html}{API Reference}
}
\seealso{
\code{\link{GetQualificationType}}

\code{\link{CreateQualificationType}}

\code{\link{DisposeQualificationType}}

\code{\link{SearchQualificationTypes}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Qualifications}
