% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHITsForQualificationType.R
\name{GetHITsForQualificationType}
\alias{GetHITsForQualificationType}
\alias{ListHITsForQualificationType}
\alias{gethitsbyqual}
\title{Get HITs by Qualification}
\usage{
GetHITsForQualificationType(qual, results = as.integer(100),
  pagetoken = NULL, verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{qual}{A character string containing a QualificationTypeId.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the HITId and other requested
characteristics of the qualifying HITs.
}
\description{
Retrieve HITs according to the QualificationTypes that are required to
complete those HITs.
}
\details{
A function to retrieve HITs that require the specified QualificationType.

\code{gethitsbyqual()} and \code{ListHITsForQualificationType()} are aliases.
}
\examples{

\dontrun{
GetHITsForQualificationType()
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html}{API Reference}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{HITs}
\keyword{Qualifications}
