% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMARC.R
\name{qcba}
\alias{qcba}
\title{qCBA Quantitative CBA}
\usage{
qcba(cbaRuleModel, datadf, extendType = "numericOnly",
  defaultRuleOverlapPruning = "transactionBased", attributePruning = TRUE,
  trim_literal_boundaries = TRUE, continuousPruning = FALSE,
  postpruning = "cba", fuzzification = FALSE, annotate = FALSE,
  ruleOutputPath, minImprovement = 0, minCondImprovement = -1,
  minConf = 0.5,
  extensionStrategy = "ConfImprovementAgainstLastConfirmedExtension",
  loglevel = "WARNING", createHistorySlot = FALSE, timeExecution = FALSE)
}
\arguments{
\item{cbaRuleModel}{a \link{CBARuleModel}}

\item{datadf}{data frame with training data}

\item{extendType}{possible extend types - numericOnly or noExtend}

\item{defaultRuleOverlapPruning}{pruning removing rules made redundant by the default rule; possible values: \code{noPruning}, \code{transactionBased}, \code{rangeBased}, \code{transactionBasedAsFirstStep}}

\item{attributePruning}{remove redundant attributes}

\item{trim_literal_boundaries}{trimming of literal boundaries enabled}

\item{continuousPruning}{indicating continuous pruning is enabled}

\item{postpruning}{type of  postpruning (\code{none}, \code{cba} - data coverage pruning, \code{greedy} - data coverage pruning stopping on first rule with total error worse than default)}

\item{fuzzification}{boolean indicating if fuzzification is enabled. Multi-rule classification model is produced if enabled. Fuzzification without annotation is not supported.}

\item{annotate}{boolean indicating if annotation with probability distributions is enabled, multi-rule classification model is produced if enabled}

\item{ruleOutputPath}{path of file to which model will be saved. Must be set if multi rule classification is produced.}

\item{minImprovement}{parameter ofqCBA extend procedure  (used when  \code{extensionStrategy=ConfImprovementAgainstLastConfirmedExtension} or \code{ConfImprovementAgainstSeedRule})}

\item{minCondImprovement}{parameter ofqCBA extend procedure}

\item{minConf}{minimum confidence  to accept extension (used when  extensionStrategy=MinConf)}

\item{extensionStrategy}{possible values: \code{ConfImprovementAgainstLastConfirmedExtension}, \code{ConfImprovementAgainstSeedRule},\code{MinConf}}

\item{loglevel}{logger level from \code{java.util.logging}}

\item{createHistorySlot}{creates a history slot on the resulting \link{qCBARuleModel} model, which contains an ordered list of extensions
that were created on input rules during the extension process}

\item{timeExecution}{reports execution time of the extend step}
}
\value{
Object of class \link{qCBARuleModel}.
}
\description{
Creates QCBA model by from a CBA rule model.
The default values are set so that the function postprocesses CBA models, reducing their size. 
The resulting model has the same structure as CBA model: it is composed of an ordered list of crisp conjunctive rules,  intended to be applied for one-rule classification.
The experimental \code{annotate} and \code{fuzzification} parameters will trigger more complex postprocessing of CBA models: 
rules will be annotated with probability distributions and optionally fuzzy borders. The intended use of such models is multi-rule classification.
The \link{predict} function automatically determines whether the input model is a CBA model or an annotated model.
}
\examples{
allData <- datasets::iris[sample(nrow(datasets::iris)),]
trainFold <- allData[1:100,]
testFold <- allData[101:nrow(datasets::iris),]
rmCBA <- cba(trainFold, classAtt="Species")
rmqCBA <- qcba(cbaRuleModel=rmCBA,datadf=trainFold)
print(rmqCBA@rules)
}
