% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalRTable.R
\name{CalRTable}
\alias{CalRTable}
\title{Calculate RNA volume for reverse transcription.}
\arguments{
\item{data}{A data.frame contained the sample names and the concentration value. The default unit of concentration is ng/uL.}

\item{template}{A data.frame contained the information of reverse transcription.}

\item{RNA.weight}{RNA weight required for reverse transcription. Default is 1 ug.}
}
\value{
A list contain a table and a figure.
}
\description{
The first step of qPCR is usually the preparation of cDNA.
We need to calculate the column of RNA for reverse transcription to cDNA.
So, if we have the concentration of RNA, we can use the function `CalRTable` to do that.
}
\examples{
df.1.path <- system.file("examples", "crtv.data.txt", package = "qPCRtools")
df.2.path <- system.file("examples", "crtv.template.txt", package = "qPCRtools")
df.1 <- data.table::fread(df.1.path)
df.2 <- data.table::fread(df.2.path)
result <- CalRTable(data = df.1, template = df.2, RNA.weight = 2)
head(result)
}
\author{
Xiang LI <lixiang117423@gmail.com>
}
