% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{datatrade_EU}
\alias{datatrade_EU}
\title{Example Trade Data for the European Union}
\format{
A list of four data frames:
\itemize{
\item \strong{extra_import} \verb{ } Data on imports from countries outside of the EU.
A data frame with 216 rows and 4 columns:
\tabular{lll}{
\code{reporter} \tab \verb{ } \tab NUTS0 code of the importing country.\cr
\tab \cr
\code{partner} \tab \verb{ } \tab ID of the exporting countries, coded
as "Extra_Total" for all external countries, and "CNTR_1", "CNTR_2",
"CNTR_3" to indicate individual non-EU countries where the pest is present.\cr
\tab \cr
\code{time_period} \tab \verb{ } \tab Time period of trade, with values
2020 and 2021.\cr \tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity imported.\cr
}}
\itemize{
\item \strong{intra_trade} \verb{ } Data on internal trade within EU member countries.
A data frame with 1404 rows and 4 columns:
\tabular{lll}{
\code{reporter} \tab \verb{ } \tab NUTS0 code of the importing country.\cr
\tab \cr
\code{partner} \tab \verb{ } \tab NUTS0 code of the exporting country.\cr
\tab \cr
\code{time_period} \tab \verb{ } \tab Time period of trade, with values
2020 and 2021.\cr \tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity imported.\cr
}}
\itemize{
\item \strong{internal_production} \verb{ } Data on the internal production of
the commodity within the EU. A data frame with 54 rows and 3 columns:
\tabular{lll}{
\code{reporter} \tab \verb{ } \tab NUTS0 code of the producing country.\cr
\tab \cr
\code{time_period} \tab \verb{ } \tab Time period of trade, in years
(2020 and 2021).\cr \tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity produced.\cr
}}
\itemize{
\item \strong{consumption_nuts1} \verb{ } Data on the consumption of the commodity
in the EU at NUTS1 level (administrative divisions). A data frame with 92 rows
and 2 columns:
\tabular{lll}{
\code{NUTS_ID} \tab \verb{ } \tab NUTS1 code of the administrative division.\cr
\tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity consumed.\cr
}}
}
\usage{
datatrade_EU
}
\description{
Simulated trade data for a commodity within the European Union (EU).
This dataset illustrates the trade and production flow of a commodity that could
serve as a potential pathway for the entry of a pest into EU countries, in yearly
time periods. It also includes simulated consumption data for the commodity at NUTS1 level.
This dataset serves as a reference for how the data should be structured and as
a basis for the examples included in the \link{qPRAentry} package to deal with the NUTS
code system
(\href{https://ec.europa.eu/eurostat/web/nuts}{Nomenclature of territorial units for statistics}).
}
\keyword{datasets}
