% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lso.R
\name{lso}
\alias{lso}
\title{List object sizes and types}
\usage{
lso(
  pos = 1,
  pattern,
  order.by = "Size",
  decreasing = TRUE,
  head = TRUE,
  n = 10
)
}
\arguments{
\item{pos}{a number specifying the environment as a position in the search list.}

\item{pattern}{an optional \link{regular expression}. Only names matching pattern are returned. \link{glob2rx} can be used to convert wildcard patterns to regular expressions.}

\item{order.by}{column to sort the list by. Values are \code{"Type"}, \code{"Size"}, \code{"Rows"}, and \code{"Columns"}.}

\item{decreasing}{logical. If \code{FALSE}, the list is sorted in ascending order.}

\item{head}{logical. Should output be limited to \code{n} lines?}

\item{n}{if \code{head=TRUE}, number of rows should be displayed?}
}
\value{
a data.frame with four columns (Type, Size, Rows, Columns) and object names as row names.
}
\description{
\code{lso} lists object sizes and types.
}
\details{
This function list the sizes and types of all objects in an environment.
By default, the list describes the objects in the current environment, presented in descending order
by object size and reported in megabytes (Mb).
}
\examples{
data(cardata)
data(cars74)
lso()
}
\references{
\url{https://stackoverflow.com/questions/1358003/tricks-to-manage-the-available-memory-in-an-r-session/}.
}
\author{
Based on based on postings by Petr Pikal and David Hinds to the r-help list in 2004 and
modified Dirk Eddelbuettel, Patrick McCann, and Rob Kabacoff.
}
