% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\title{Frequency distribution for a categorical variable}
\usage{
tab(
  data,
  x,
  sort = FALSE,
  maxcat = NULL,
  minp = NULL,
  na.rm = FALSE,
  total = FALSE,
  digits = 2,
  cum = FALSE,
  plot = FALSE
)
}
\arguments{
\item{data}{A dataframe}

\item{x}{A factor variable in the data frame.}

\item{sort}{logical. Sort levels from high to low.}

\item{maxcat}{Maximum number of categories to be included.
Smaller categories will be combined into an "Other" category.}

\item{minp}{Minimum proportion for a category to be included.
Categories
representing smaller proportions willbe combined into an
"Other" category.
maxcat and minp cannot both be specified.}

\item{na.rm}{logical. Removes missing values when TRUE.}

\item{total}{logical. Include a total category when TRUE.}

\item{digits}{Number of digits the percents should be rounded to.}

\item{cum}{logical. If \code{TRUE}, include cumulative counts
and percents. In this case \code{total} will be set to \code{FALSE}.}

\item{plot}{logical. If \code{TRUE}, generate bar chart rather than a frequency table.}
}
\value{
If \code{plot = TRUE} return a ggplot2 bar chart. Otherwise
return a data frame.
}
\description{
Function to calculate frequency distributions
for categorical variables
}
\details{
The function \code{tab} will calculate the frequency
distribution for a categorical variable and output a data frame
with three columns: level, n, percent.
}
\examples{
tab(cars74, carb)
tab(cars74, carb, plot=TRUE)
tab(cars74, carb, sort=TRUE)
tab(cars74, carb, sort=TRUE, plot=TRUE)
tab(cars74, carb, cum=TRUE)
tab(cars74, carb, cum=TRUE, plot=TRUE)
}
