% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_qad.R
\name{predict.qad}
\alias{predict.qad}
\title{Predict conditional probabilities}
\usage{
\method{predict}{qad}(object, values, conditioned = c("x1", "x2"),
  nr_intervals = NULL, prediction_interval = NULL, copula = FALSE,
  pred_plot = FALSE, panel.grid = TRUE, ...)
}
\arguments{
\item{object}{an object of class 'qad', which determines the underlying checkerboard aggregation.}

\item{values}{a vector containing the x or the y values for which the conditional probabilities should be predicted.}

\item{conditioned}{a character specifying on which variable is conditioned. Options are "x1" (default) or "x2".}

\item{nr_intervals}{an integer, which determines the number of intervals for the prediction. Note, that in the copula setting
the intervals are equidistant, in the data setting the retransformed intervals have different lengths. (default = NULL: the number of intervals is the
resolution of the checkerboard copula)}

\item{prediction_interval}{a vector specifying the interval boundaries for which the conditional probability is computed. Options are NULL (default) to predict the conditional probabilites for all intervals or a vector c(lower_boundary, upper_boundary) indicating the boundaries.}

\item{copula}{a logical (default =FALSE) determining whether the empirical checkerboard copula is used or the retransformed data.}

\item{pred_plot}{a logical indicating if the conditional probabilites are plotted.}

\item{panel.grid}{a logical indicating whether the panel.grid is plotted.}

\item{...}{some methods for this generic require additional arguments.  None are used in this method.}
}
\value{
a named data.frame and a plot (optional). Each row stands for an evaluation point and the columns contain the conditional probabilities of the intervals.
}
\description{
The function \code{predict.qad()} predicts the probabilities
to end up in specific intervals given x or y values and plots the conditional probabilities.
The prediction can be computed in the copula setting
or in the data setting.
}
\note{
Predictions are only possible for values within the range of the sample (or between 0 and 1 in the copula setting). Values exceeding the range are removed.
}
\examples{
n <- 1000
x <- runif(n, -1 ,1)
y <- x^2 + rnorm(n, 0, 1)
sample <- data.frame(x, y)

##(Not Run)
#mod <- qad(sample)
#val <- c(-0.5, 0,1)
#predict(mod, values = val, conditioned = "x1", copula = FALSE, pred_plot = TRUE)
#predict(mod, values = val, conditioned = "x1", copula = TRUE)
#predict(mod, values = val, conditioned = "x1", copula = TRUE, pred_plot = TRUE)


}
