% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_boot.R
\name{boot}
\alias{boot}
\title{Inference on QC-PM model parameters (i.e., loadings and path coefficients)}
\usage{
boot(qcpm, conf.level = 0.95, br = 200)
}
\arguments{
\item{qcpm}{is an object of class \code{qcpm}.}

\item{conf.level}{is the value used to fix the confidence level to use for the 
confidence interval. It is equal to 0.95 by default.}

\item{br}{specifies the number of bootstrap replications. It is fixed to 
\code{200} by default.}
}
\value{
\item{boot.loadings}{the outer loading results for each considered quantile.}

\item{boot.path}{the path coefficient results for each considered quantile.}
}
\description{
\code{boot} returns in order the estimates, std. errors, t-values, 
p-values, and confidence interval at the specified confidence level 
for loadings and path coefficients for each quantile.
}
\details{
The argument \code{qcpm} is an object of class qcpm returned by \code{qcpm} function. 
Std. errors are calculated by using the bootstrap method implemented in the 
\code{tidy.rq} function of the broom package  (Robinson, 2014). When \code{fix.quantile=TRUE}, 
the function boot returns only loading results for the quantile 0.5.
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

# Define the model using laavan sintax. Use a set of regression formulas defining 
# firstly the structural model and then the measurement model
model <- "
ECOW ~ EDU
HEALTH ~ EDU + ECOW

# Reflective measurement model
EDU =~ EDU1 + EDU2 + EDU3 + EDU4 + EDU5 + EDU6 + EDU7
ECOW =~ ECOW1 + ECOW2 + ECOW3 + ECOW4 + ECOW5 + ECOW6
HEALTH =~  HEALTH1 + HEALTH2 + HEALTH3
"


# Apply qcpm
well.qcpm = qcpm(model,province)
well.boot = boot(well.qcpm)   
well.boot 

}
\references{
Davino, C., Dolce, P., Taralli, S. and Vistocco, D. (2020). Composite-based 
path modeling for conditional quantiles prediction. An application to assess 
health differences at local level in a well-being perspective.
\emph{Social Indicators Research}, doi:10.1007/s11205-020-02425-5.

Davino, C. and Esposito Vinzi, V. (2016). Quantile composite-based path modeling. 
\emph{Advances in Data Analysis and Classification}, \bold{10 (4)}, pp. 
491--520, doi:10.1007/s11634-015-0231-9.

Dolce, P., Davino, C. and Vistocco, D. (2021). Quantile composite-based path modeling: 
algorithms, properties and applications. \emph{Advances in Data Analysis and Classification},
doi:10.1007/s11634-021-00469-0.

Robinson, D. (2014). broom: An R package for converting statistical analysis 
objects into tidy data frames. Available at 
\url{https://CRAN.R-project.org/package=broom}.
}
\seealso{
\code{\link{qcpm}}, \code{\link{assessment}}, \code{\link{summary}}, and 
\code{\link{reliability}}
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
