% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcr.R
\docType{data}
\name{pistonrings}
\alias{pistonrings}
\title{Piston rings data}
\format{A data frame with 200 observations on the following 3 variables.
\describe{ 
\item{diameter}{a numeric vector}
\item{sample}{sample ID}
\item{trial}{trial sample indicator (TRUE/FALSE)}
 }}
\description{
Piston rings for an automotive engine are produced by a forging process.
The inside diameter of the rings manufactured by the process is measured on
25 samples, each of size 5, drawn from a process being considered 'in
control'.
}
\examples{

data(pistonrings)
attach(pistonrings)
summary(pistonrings)
boxplot(diameter ~ sample)
plot(sample, diameter, cex=0.7)
lines(tapply(diameter,sample,mean))
detach(pistonrings)
}
\references{
Montgomery, D.C. (1991) \emph{Introduction to Statistical
Quality Control}, 2nd ed, New York, John Wiley & Sons, pp. 206--213
}
\keyword{datasets}

