% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.cusum.r
\name{qcs.cusum}
\alias{qcs.cusum}
\alias{qcs.cusum.default}
\alias{qcs.cusum.qcd}
\title{Function to plot the cusum chart}
\usage{
qcs.cusum(x, ...)

\method{qcs.cusum}{default}(x, var.index = 1, sample.index = 2,
  covar.index = NULL, covar.names = NULL, data.name = NULL,
  sizes = NULL, center = NULL, std.dev = NULL, decision.interval = 5,
  se.shift = 1, plot = FALSE, ...)

\method{qcs.cusum}{qcd}(x, center = NULL, std.dev = NULL,
  decision.interval = 5, se.shift = 1, plot = FALSE, ...)
}
\arguments{
\item{x}{Object qcd (Quality Control Data)}

\item{...}{arguments passed to or from methods.}

\item{var.index}{a scalar with the column number corresponding to the observed data for
the variable (the variable quality).  Alternativelly can be a string with the
name of the quality variable.}

\item{sample.index}{a scalar with the column number corresponding to the index each
group (sample).}

\item{covar.index}{optional. A scalar or numeric vector with the column number(s)
corresponding to the covariate(s). Alternativelly it can be a character vector with
the names of the covariates.}

\item{covar.names}{optional. A string or vector of strings with names for the
covariate columns.  Only valid if there is more than one column of data. By
default, takes the names from the original object.}

\item{data.name}{a string specifying the name of the variable which appears on the
plots. If not provided it is taken from the object given as data.}

\item{sizes}{a value or a vector of values specifying the sample sizes
associated with each group.}

\item{center}{a value specifying the center of group statistics or the
''target'' value of the process.}

\item{std.dev}{a value or an available method specifying the within-group
standard deviation(s) of the process. \cr Several methods are available for
estimating the standard deviation.}

\item{decision.interval}{A numeric value specifying the number of standard
errors of the summary statistics at which the cumulative sum is out of
control.}

\item{se.shift}{The amount of shift to detect in the process, measured in
standard errors of the summary statistics.}

\item{plot}{a logical value indicating it should be plotted.}
}
\description{
This function is used to compute statistics required by the cusum chart.
}
\examples{

library(qcr)
data(pistonrings)
attach(pistonrings)
res.qcd <- qcd(pistonrings, type.data = "dependence")
res.qcs <- qcs.cusum(res.qcd, type = "cusum")
summary(res.qcs)
plot(res.qcs)

}

