% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.r
\name{state.control}
\alias{state.control}
\title{Univariante process state}
\usage{
state.control(x)
}
\arguments{
\item{x}{Object qcs (Quality Control Statistical)}
}
\description{
This function removes observations from the sample which violates 
the rules of a process under control
}
\examples{

##
##  Continuous data 
##
library(qcr)
data(pistonrings)
str(pistonrings)
pistonrings.qcd<-qcd(pistonrings)

class(pistonrings.qcd)

res.qcs <- qcs.xbar(pistonrings.qcd)
plot(res.qcs,title="Control Chart Xbar for pistonrings I")
summary(res.qcs)  

res.qcd <- state.control(res.qcs)
res.qcs <- qcs.xbar(res.qcd)
plot(res.qcs,title="Control Chart Xbar for pistonrings II")
summary(res.qcs)  

res.qcd <- state.control(res.qcs)
res.qcs <- qcs.xbar(res.qcd)
plot(res.qcs,title="Control Chart Xbar for pistonrings III")
summary(res.qcs)  

}

