% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_city_state_zip}
\alias{rm_city_state_zip}
\title{Remove/Replace/Extract City, State, & Zip}
\usage{
rm_city_state_zip(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_city_state_zip", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_city_state_zip} uses the
\code{rm_city_state_zip} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the city, state, & zip are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with city, state, & zip removed.
}
\description{
Remove/replace/extract city (single lower case word or multiple consecutive
capitalized words before a comma and state) + state (2 consecutive capital
letters) + zip code (5 digits or 5 + 4 digits) from a string.
}
\examples{
x <- paste0("I went to Washington Heights, NY 54321 for food! ",
   "It's in West ven,PA 12345, near Bolly Bolly Bolly, CA12345-1234!",
   "hello world")
rm_city_state_zip(x)
rm_city_state_zip(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{date}

